program dkm2md2;

uses
   sysutils,
  models in 'models.pas';

begin
   writeln('Dkm2Md2 convert Daikatana models to Quake 2 models');
   writeln('by Charles Hollemeersch (2001)');
   if ParamCount  = 0 then
   begin
      writeln('Usage: "Dkm2Md2 filename.dkm [skinWidth skinHeight] [skinName]"');
      writeln('The converted file will be saved as filename.md2');
      writeln('If no skin size is specified 256*256 is assumed');
      writeln('If no skin file name is specified filename.pcx is used');
      exit;
   end;

   case ParamCount of
        1: begin
                StringToSkin(ChangeFileExt(ParamStr(1),'.pcx'));
           end;
        2: begin
                writeln('Missing skin height.');
                exit;
           end;
        3: begin
                userSkinWidth := StrToInt(ParamStr(2));
                userSkinHeight := StrToInt(ParamStr(3));
                StringToSkin(ChangeFileExt(ParamStr(1),'.pcx'));
           end;
        4: begin
                userSkinWidth := StrToInt(ParamStr(2));
                userSkinHeight := StrToInt(ParamStr(3));
                StringToSkin(ParamStr(4));
           end;
   end;

   case PeekVersion(ParamStr(1)) of
        1: ConvertVer1(ParamStr(1));
        2: ConvertVer2(ParamStr(1));
       -1: Writeln('File not found: ',ParamStr(1));
   end;
end.
