//******************************************************************************
//
// Game project unit
// (c) 1999 Charles Hollemeesch
// Description: Model definitons,loading and creating
//******************************************************************************
unit models;

interface
uses classes,sysutils,gl,dialogs,textures,globals,text_obj;
const maxtriangles = 4096;
      maxvertices  = 2048;
      maxtexco     = 2048;
      maxframes    = 512;
      maxskins     = 10;
      maxlinks     = 4;
Type Tvec3 = record
	x,y,z : Single;
  end;
 tmdlheader = record
     magic : array [0..3] of char;   // must be idp2
     version : integer;              // quake2 = version 8
     skinWidth : integer;            // witdth of skins
     skinHeight : integer;           // height of skins
     frameSize : integer;            //size in byes of one frame
     numSkins : integer;             // number of xxx
     numVertices : integer;
     numTexCoords : integer;
     numTriangles : integer;
     numGlCommands : integer;
     numFrames : integer;
     offsetSkins : integer;          // byte ofset for xxx
     offsetTexCoords : integer;
     offsetTriangles : integer;
     offsetFrames : integer;
     offsetGlCommands : integer;
     offsetEnd : integer;
     end;
TTriangleVertex = record
   x,y,z : byte;
   lightNormalIndex : byte;
   end;
Tframe = record
   scalex,scaley,scalez : single;            // scale to decode vertexes
   translatex,translatey,translatez : single;// translation to decode vertexes
   name : array [0..15] of char;             // name of frame
   vertices : array[0..0]of TtriangleVertex;
   end;

 pframe = ^Tframe;

 TTriangle = record
   vertexIndices : array[0..2] of smallint;
   textureIndices: array[0..2] of smallint;
   end;
 TTextureCoordinate = record
   s,t : smallint;
   end;

 TglCommandVertex = record
   s, t : single;
   vertexIndex : integer;
end;

 TModelInfo = record
     frameSize : integer;  //size in byes of one frame
     numSkins : integer;   // number of xxx
     //numVertices : integer;
     //numTexCoords : integer;
     //numTriangles : integer;
     numGlCommands : integer;
     numFrames : integer;
     numLinks : Integer;
     end;

 TskinName = array[0..63] of char;

 TLinkedModel = record
              index,
              skin,
              frame : byte;
              end;
              
 Pmodel = ^tmodel;
 Tmodel = record
  Info         : TModelInfo;
  Frames       : ^Tframe;
  SkinsGlIndex : array[0..maxskins-1] of integer;
  GlCmds       : ^Longint;
  calllist     : integer;
  links        : array[0..maxlinks-1] of TLinkedModel;
  flags        : word;
  //removed because of glcommands
  //frames     : array [0..maxframes] of Tframe;
  //Triangles  : array[0..maxtriangles]       of TTriangle;
  //TextureCoos: array[0..maxtexco]          of TTextureCoordinate;
  end;


procedure loadmodel(mdlObject : pmodel;filename : string);
procedure drawmodel(mdlObject : pmodel;aframe : integer);
procedure freemodel(mdlObject : pmodel);
procedure ParticulateModel(mdlObject : pmodel;pos : TVector3d;aframe : integer);
procedure drawmodelshadow(mdlObject : pmodel;aframe,angle : integer);
procedure gencallLists;

implementation

uses pakfiles,normals,gl_console,objects,particles,mymath;

procedure gencallLists;
begin
  glNewList(1, GL_COMPILE);
    //links rechts
    gltranslatef(0,10,0);
    glBegin(GL_POLYGON);

      glNormal3f(0.0, 0.0, 1.0);
      glTexCoord2f(0.5,0);
      glVertex3f(10.0, 10.0, 10.0);

      glTexCoord2f(0.5,0.5);
      glVertex3f(10.0, -10.0, 10.0);

      glTexCoord2f(0,0.5);
      glVertex3f(-10.0, -10.0, 10.0);


      glTexCoord2f(0,0);
      glVertex3f(-10.0, 10.0, 10.0);

    glEnd;

    //p
    glBegin(GL_POLYGON);
      glNormal3f(0.0, 0.0, -1.0);
      glTexCoord2f(0,0);
      glVertex3f(10.0, 10.0, -10.0);

      glTexCoord2f(0.5,0);
      glVertex3f(-10.0, 10.0, -10.0);

      glTexCoord2f(0.5,0.5);
      glVertex3f(-10.0, -10.0, -10.0);

      glTexCoord2f(0,0.5);
      glVertex3f(10.0, -10.0, -10.0);

    glEnd;

    //voor achter
    glBegin(GL_POLYGON);
      glNormal3f(-1.0, 0.0, 0.0);
      glTexCoord2f(1,0);
      glVertex3f(-10.0, 10.0, 10.0);

      glTexCoord2f(1,0.5);
      glVertex3f(-10.0, -10.0, 10.0);

      glTexCoord2f(0.5,0.5);
      glVertex3f(-10.0, -10.0, -10.0);

      glTexCoord2f(0.5,0);
      glVertex3f(-10.0, 10.0, -10.0);

    glEnd;
    //p2
    glBegin(GL_POLYGON);
      glNormal3f(1.0, 0.0, 0.0);
      glTexCoord2f(0.5,0);
      glVertex3f(10.0, 10.0, 10.0);

      glTexCoord2f(1,0);
      glVertex3f(10.0, 10.0, -10.0);

      glTexCoord2f(1,0.5);
      glVertex3f(10.0, -10.00, -10.0);

      glTexCoord2f(0.5,0.5);
      glVertex3f(10.0, -10.0, 10.0);
    glEnd;

    //boven
    glBegin(GL_POLYGON);
      glNormal3f(0.0, 1.0, 0.0);
      glTexCoord2f(0.5,1);
      glVertex3f(-10.0, 10.0, -10.0);

      glTexCoord2f(0,1);
      glVertex3f(10.0, 10.0, -10.0);

      glTexCoord2f(0,0.5);
      glVertex3f(10.0, 10.0, 10.0);

      glTexCoord2f(0.5,0.5);
      glVertex3f(-10.0, 10.0, 10.0);

    glEnd;

    //onder
    glBegin(GL_POLYGON);
      glNormal3f(0.0, -1.0, 0.0);
      glTexCoord2f(1,1);
      glVertex3f(-10.0, -10.0, -10.0);

      glTexCoord2f(0.5,1);
      glVertex3f(-10.0, -10.0, 10.0);


      glTexCoord2f(0.5,0.5);
      glVertex3f(10.0, -10.0, 10.0);

      glTexCoord2f(1,0.5);
      glVertex3f(10.0, -10.0, -10.0);
    glEnd;

  glEndList ();
//bloc

  glNewList(2, GL_COMPILE);
    //links rechts
    glscalef(1.5,1.5,1.5);
    glrotatef(-90,0,1,0);
    glBegin(GL_POLYGON);
      glNormal3f(0.0, 0.0, 1.0);
      glTexCoord2f(1,0);
      glVertex3f(10, 10, 5);

      glTexCoord2f(1,0.5);
      glVertex3f(10, 0, 5);

      glTexCoord2f(0.5,0.5);
      glVertex3f(-10, 0, 5);

      glTexCoord2f(0.5,0);
      glVertex3f(-10, 10, 5);

    glEnd;

    glBegin(GL_POLYGON);
      glNormal3f(0.0, 0.0, -1.0);
      glTexCoord2f(0.5,0.5);
      glVertex3f(10, 10, -5);

      glTexCoord2f(1,0.5);
      glVertex3f(-10, 10, -5);

      glTexCoord2f(1,1);
      glVertex3f(-10, 0, -5);

      glTexCoord2f(0.5,1);
      glVertex3f(10, 0, -5);

    glEnd;

    //voor achter
    glBegin(GL_POLYGON);
      glNormal3f(-1.0, 0.0, 0.0);
      glTexCoord2f(0.5,0);
      glVertex3f(-10, 10, 5);

      glTexCoord2f(0.5,0.5);
      glVertex3f(-10, 0, 5);

      glTexCoord2f(0.25,0.5);
      glVertex3f(-10, 0, -5);

      glTexCoord2f(0.25,0);
      glVertex3f(-10, 10, -5);

    glEnd;
    //p2
    glBegin(GL_POLYGON);
      glNormal3f(1.0, 0.0, 0.0);
      glTexCoord2f(0,0);
      glVertex3f(10, 10, 5);

      glTexCoord2f(0.25,0);
      glVertex3f(10, 10, -5);

      glTexCoord2f(0.25,0.5);
      glVertex3f(10, 0, -5);

      glTexCoord2f(0,0.5);
      glVertex3f(10, 0, 5);
    glEnd;

    //boven
    glBegin(GL_POLYGON);
      glNormal3f(0.0, 1.0, 0.0);
      glTexCoord2f(0.5,1);
      glVertex3f(-10, 10, -5);

      glTexCoord2f(0,1);
      glVertex3f(10, 10, -5);

      glTexCoord2f(0,0.5);
      glVertex3f(10, 10, 5);

      glTexCoord2f(0.5,0.5);
      glVertex3f(-10, 10, 5);

    glEnd;

    //onder
    glBegin(GL_POLYGON);
      glNormal3f(0.0, -1.0, 0.0);
      glTexCoord2f(1,1);
      glVertex3f(-10, 0, -5);

      glTexCoord2f(0.5,1);
      glVertex3f(-10, 0, 5);


      glTexCoord2f(0.5,0.5);
      glVertex3f(10, 0, 5);

      glTexCoord2f(1,0.5);
      glVertex3f(10, 0, -5);
    glEnd;

  glEndList ();

end;

procedure LoadModel(mdlObject : pmodel;filename : string);
var
   mdlfile : File;
   Header  : TmdlHeader;
   Skins   : array[0..9] of Tskinname;
   pakoffset,paksize : longint;
begin

if pakassignresetfile(mdlfile,filename,pakoffset,paksize) <> OK then
   begin mdlObject.GlCmds := nil;
         exit;
         end;

//try
with mdlobject^ do
begin

fillchar(mdlobject^,sizeof(tmodel),0);

Blockread(mdlfile,Header, Sizeof(header));
// Load Gl commands
Getmem(GlCmds,Header.NumGlCommands * sizeof(longint));
seek(mdlfile,Header.OffsetGlCommands+pakoffset);
blockread(mdlfile,glcmds^,sizeof(longint) * header.numglcommands);

// Load the Frames

Getmem(Frames,Header.NumFrames * Header.Framesize);
seek(mdlfile,Header.OffsetFrames+pakoffset);
blockread(mdlfile,Frames^,Header.Framesize * Header.NumFrames);

// Load the triangles

   // no need for triangles using openlg

// Load the texture File names
seek(mdlfile,Header.OffsetSkins+pakoffset);
blockread(mdlfile,skins,64 * Header.Numskins);

//save the info from the model header

 mdlobject^.info.frameSize     := header.framesize;  //size in byes of one frame
 info.numSkins      := header.numSkins;   // number of xxx
 info.numGlCommands := header.numGlCommands;
 info.numFrames     := header.numFrames;
 info.numlinks      := 0;
// Load the texture coordinates

   // no need for texture coos using opengl

end; // with

//finally
closefile(mdlfile);
mdlobject^.callList := 0;
mdlobject^.flags := 0;
//end;
end;

//****************************************************************
//
//Model Drawing
//
//****************************************************************

type PLongInt = ^LongInt;
const nextitem = 4;
procedure RawDrawmodel(var command : PLongint;const FrameInfo : PFrame); forward;
procedure EnviroDrawmodel(var command : PLongint;const FrameInfo : PFrame); forward;
//procedure DrawmodelSoftLight(var command : PLongint;const FrameInfo : PFrame); forward;
procedure ShadeDrawmodel(command : PLongint;FrameInfo : PFrame); forward;
//================================================
//code that is the same for all the drawing modes
//================================================
procedure DrawModel(mdlObject : pmodel;aframe : integer);
var Command : PLongInt;
    FrameInfo : PFrame;
begin

//those boxes are hardcoded callists
if mdlobject^.callList <> 0 then begin
                                 glcolor3ubv(@modelcolor);
                                 glcallList(mdlobject^.callList);
                                 exit;
                                 end;

if aframe > mdlobject^.info.numframes-1 then begin std_err('invalid frame '+inttostr(aframe)); exit; end;

Frameinfo := pframe(pointer(cardinal(mdlobject^.frames) + mdlobject^.Info.framesize*aframe));

command := pointer(mdlobject^.glcmds);
glPushMatrix;
gltranslatef(frameinfo.translatey,frameinfo.translatez,frameinfo.translatex);
glscalef(frameinfo.scaley,frameinfo.scalez,frameinfo.scalex);

//setup gl state
if (mdlObject.Flags and MODEL_FLAG_TRANSPARENT) = MODEL_FLAG_TRANSPARENT then
   begin
   glEnable(GL_BLEND);
   end;

{if (mdlObject.Flags and MODEL_FLAG_BILLBOARd) = MODEL_FLAG_BILLBOARD then
   begin
//   std_write('billboared drawn');
   glEnable(GL_ALPHA_TEST);
   end;}

if (mdlObject.Flags and MODEL_FLAG_NOLIGHT) = MODEL_FLAG_NOLIGHT then
   IF HardwareLight then glDisable(GL_LIGHTING)
   else modelcolor := glcolora(255,255,255,255);

//draw the model
   if (mdlObject.Flags and MODEL_FLAG_ENVIROMENT) = MODEL_FLAG_ENVIROMENT then
      begin
      glmatrixmode(GL_TEXTURE);
      glPushMatrix;
      glLoadIdentity;
      glrotatef(camera.heading,0,1,0);
      glrotatef(camera.roll,1,0,1);
      EnviroDrawModel(command,frameinfo);
      glPopMatrix;
      glMatrixMode(GL_MODELVIEW);
      end
      else
      if HardwareLight then RawDrawmodel(command,frameinfo) else
         ShadeDrawModel(command,frameinfo);

//reset gl state
if (mdlObject.Flags and MODEL_FLAG_NOLIGHT) = MODEL_FLAG_NOLIGHT then
   IF HardwareLight then glEnable(GL_LIGHTING);

if (mdlObject.Flags and MODEL_FLAG_TRANSPARENT) = MODEL_FLAG_TRANSPARENT then
   begin
   glDisable(GL_BLEND);
   end;

{if (mdlObject.Flags and MODEL_FLAG_TRANSPARENT) = MODEL_FLAG_TRANSPARENT then
   begin
   glDisable(GL_ALPHA_TEST);
   end;}

glPopMatrix;
end;

//================================================
//specific code
//================================================

//draw with poly's,texcoo's and normals
procedure RawDrawmodel(var command : PLongint;const FrameInfo : PFrame);
var
//command       : ^Longint; // = dword i hope
//frameinfo     : pframe;
num_verts,i,vert_index : integer;
s,t           : GlFloat;
begin
while true do
 begin
    num_verts := command^;
    inc(cardinal(command),nextitem);

    if num_verts = 0 then break;
    if num_verts < 0 then
    begin
    // triangle strip
    num_verts := -num_verts;
    glBegin(GL_TRIANGLE_FAN);
    end else
    begin
    // triangle fan
    glBegin(GL_TRIANGLE_STRIP);
    end;

    for i := 0 to num_verts-1 do
        begin
        // get texture coos
        s := glfloat(pointer(command^));
        inc(cardinal(command),nextitem);// next 4 bytes integer

        t := glfloat(pointer(command^));
        inc(cardinal(command),nextitem);// next 4 bytes integer

        // get vertex index and data
        vert_index := command^;
        inc(cardinal(command),nextitem);// next 4 bytes integer

        //enable this for shaded models
        //shade := VertexShade[frameinfo.vertices[vert_index].lightnormalindex];
        //glcolor3f(shade,shade,shade);

        // pump into opengl
        glTexCoord2f(s,t);

        glnormal3f(Vertexnormals[frameinfo.vertices[vert_index].lightnormalindex,1],
                   Vertexnormals[frameinfo.vertices[vert_index].lightnormalindex,2],
                   Vertexnormals[frameinfo.vertices[vert_index].lightnormalindex,0]);
        glVertex3f(frameinfo.vertices[vert_index].y,frameinfo.vertices[vert_index].z,frameinfo.vertices[vert_index].x);
        end;
    glEnd;

 end;//while *)
end;

//draw model with poly's,texcoo's and lookup shaded colors
procedure ShadeDrawmodel(command : PLongint;FrameInfo : PFrame);
var
//command       : ^Longint; // = dword i hope
//frameinfo     : pframe;
num_verts,i,vert_index : integer;
s,t,shade           : GlFloat;
begin
while true do
 begin
    num_verts := command^;
    inc(cardinal(command),nextitem);

    if num_verts = 0 then break;
    if num_verts < 0 then
    begin
    // triangle strip
    num_verts := -num_verts;
    glBegin(GL_TRIANGLE_FAN);
    end else
    begin
    // triangle fan
    glBegin(GL_TRIANGLE_STRIP);
    end;

    for i := 0 to num_verts-1 do
        begin
        // get texture coos
        s := glfloat(pointer(command^));
        inc(cardinal(command),nextitem);// next 4 bytes integer

        t := glfloat(pointer(command^));
        inc(cardinal(command),nextitem);// next 4 bytes integer

        // get vertex index and data
        vert_index := command^;
        inc(cardinal(command),nextitem);// next 4 bytes integer

        //enable this for shaded models
        shade := VertexShade[frameinfo.vertices[vert_index].lightnormalindex];
        //divide by 512 because shade is also to large
        glcolor4f(modelcolor.r * shade / 512,modelcolor.g * shade / 512,modelcolor.b * shade / 512,modelcolor.a / 256);

        // pump into opengl
        glTexCoord2f(s,t);

        {glnormal3f(Vertexnormals[frameinfo.vertices[vert_index].lightnormalindex,1],
                   Vertexnormals[frameinfo.vertices[vert_index].lightnormalindex,2],
                   Vertexnormals[frameinfo.vertices[vert_index].lightnormalindex,0]);}
        glVertex3f(frameinfo.vertices[vert_index].y,frameinfo.vertices[vert_index].z,frameinfo.vertices[vert_index].x);
        end;
    glEnd;

 end;//while *)
end;

//draw model with poly's and texcoo's depenting on the normals
procedure EnviroDrawmodel(var command : PLongint;const FrameInfo : PFrame);
var
//command       : ^Longint; // = dword i hope
//frameinfo     : pframe;
num_verts,i,vert_index : integer;
s,t           : GlFloat;
begin
while true do
 begin
    num_verts := command^;
    inc(cardinal(command),nextitem);

    if num_verts = 0 then break;
    if num_verts < 0 then
    begin
    // triangle strip
    num_verts := -num_verts;
    glBegin(GL_TRIANGLE_FAN);
    end else
    begin
    // triangle fan
    glBegin(GL_TRIANGLE_STRIP);
    end;

    for i := 0 to num_verts-1 do
        begin
        // get texture coos off the list
        inc(cardinal(command),2*nextitem);// next 4 bytes integer

        // get vertex index and data
        vert_index := command^;
        inc(cardinal(command),nextitem);// next 4 bytes integer

        // pump into opengl
        glTexCoord2f(abs(Vertexnormals[frameinfo.vertices[vert_index].lightnormalindex,1]),
                     abs(Vertexnormals[frameinfo.vertices[vert_index].lightnormalindex,0]));

        {glnormal3f(Vertexnormals[frameinfo.vertices[vert_index].lightnormalindex,1],
                   Vertexnormals[frameinfo.vertices[vert_index].lightnormalindex,2],
                   Vertexnormals[frameinfo.vertices[vert_index].lightnormalindex,0]);
        }
        glVertex3f(frameinfo.vertices[vert_index].y,frameinfo.vertices[vert_index].z,frameinfo.vertices[vert_index].x);
        end;
    glEnd;

 end;//while *)
end;

//********************** draw a model shadow
procedure drawmodelshadow(mdlObject : pmodel;aframe,angle : integer);
const nextitem = 4;
var
command       : ^Longint; // = dword i hope
frameinfo     : pframe;
num_verts,i,vert_index : integer;
temp             : pointer;
s,t,shade        : GlFloat;
point :          array[0..2] of single;
height,lheight : single;
shadevector : array [0..2] of single;
size : single;
begin
if mdlobject^.callList <> 0 then begin
                                 glscalef(1,0,1);
                                 gltranslatef(-10,0,0);
                                 glCallList(mdlobject^.callList);
                                 exit;
                                 end;
  //calc shade vector
  shadevector[0] := cos(-(angle-90)/180*pi);
  shadevector[1] := sin(-(angle-90)/180*pi);
  shadevector[2] := 1;

  //normalize shade vector
  size :=  sqrt(sqr(shadevector[0])+sqr(shadevector[1])+sqr(shadevector[2]));
  shadevector[0] := shadevector[0] / size;
  shadevector[1] := shadevector[1] / size;
  shadevector[2] := shadevector[2] / size;

Frameinfo := pframe(pointer(integer(mdlobject.frames) + mdlobject.Info.framesize*aframe));
//frameinfo := mdlObject.Frames[aframe];
command := pointer(mdlobject.glcmds);
//won := 0;
glpushmatrix;
lheight := 0.1;
//height := - lheight + 1.0;
height := 1;
//glscalef(frameinfo.scaley,frameinfo.scalez,frameinfo.scalex);
//gltranslatef(frameinfo.translatey,frameinfo.translatez,frameinfo.translatex);
while true do
 begin
    num_verts := command^;
    inc(cardinal(command),nextitem);

    if num_verts = 0 then break;
    if num_verts < 0 then
    begin
    // triangle strip
    num_verts := -num_verts;
    glBegin(GL_TRIANGLE_FAN);
    end else
    begin
    // triangle fan
    glBegin(GL_TRIANGLE_STRIP);
    end;

    for i := 0 to num_verts-1 do
        begin
        // get texture coos
        //s := glfloat(command^);
        //inc(cardinal(command),nextitem);// next 4 bytes integer

        //t := glfloat(command^);
        //inc(cardinal(command),nextitem);// next 4 bytes integer
        inc(cardinal(command),nextitem*2);


        // get vertex index and data
        vert_index := command^;
        inc(cardinal(command),nextitem);// next 4 bytes integer
        // pump into opengl
        		point[0] := frameinfo.vertices[vert_index].x * frameinfo.scalex + frameinfo.translatex;
			point[1] := frameinfo.vertices[vert_index].y * frameinfo.scaley + frameinfo.translatey;
			point[2] := frameinfo.vertices[vert_index].z * frameinfo.scalez + frameinfo.translatez;

			point[0] := point[0] - shadevector[0]*(point[2]+lheight);
			point[1] := point[1] - shadevector[1]*(point[2]+lheight);
			point[2] := height;
         //glTexCoord2f(s,t);
         //glcolor3f(1,1,1);
        glVertex3f(point[1],point[2],point[0]);
        {(frameinfo.vertices[vert_index].y * frameinfo.scaley) + frameinfo.translatey,
        (frameinfo.vertices[vert_index].z * frameinfo.scalez) + frameinfo.translatez,
        (frameinfo.vertices[vert_index].x * frameinfo.scalex) + frameinfo.translatex);}
        end;
    glEnd;

 end;//while
{i := 1;
error(frameinfo.name+chr(13)+
floattostr(frameinfo.scalex)+' '+floattostr(frameinfo.scaley)+' '+floattostr(frameinfo.scalez)
+chr(13)+inttostr(frameinfo.vertices[i].x)+' '+inttostr(frameinfo.vertices[i].y)+' '+inttostr(frameinfo.vertices[i].z));}
//error(inttostr(won)+'/'+inttostr(mdlObject.Header.NumTriangles));
glpopmatrix;
end;

//********************** make a model disappear into particles
procedure ParticulateModel(mdlObject : pmodel;pos : TVector3d;aframe : integer);
var Command : PLongInt;
    FrameInfo : PFrame;
    //command       : ^Longint; // = dword i hope
    //frameinfo     : pframe;
    num_verts,i,vert_index : integer;
    s,t           : GlFloat;
begin

if aframe > mdlobject^.info.numframes-1 then begin std_err('invalid frame '+inttostr(aframe)); {aframe := 0; }exit; end;

Frameinfo := pframe(pointer(cardinal(mdlobject^.frames) + mdlobject^.Info.framesize*aframe));
command := pointer(mdlobject^.glcmds);

while true do
 begin
    num_verts := command^;
    inc(cardinal(command),nextitem);

    if num_verts = 0 then break;
    if num_verts < 0 then
    begin
    // triangle strip
    num_verts := -num_verts;
    //glBegin(GL_TRIANGLE_FAN);
    end else
    begin
    // triangle fan
    //glBegin(GL_TRIANGLE_STRIP);
    end;

    for i := 0 to num_verts-1 do
        begin
        // get texture coos
        inc(cardinal(command),nextitem);// next 4 bytes integer

        inc(cardinal(command),nextitem);// next 4 bytes integer

        // get vertex index and data
        vert_index := command^;
        inc(cardinal(command),nextitem);// next 4 bytes integer

        //enable this for shaded models
        //shade := VertexShade[frameinfo.vertices[vert_index].lightnormalindex];
        //glcolor3f(shade,shade,shade);
        pa_add(Vector3d(((frameinfo.vertices[vert_index].y + frameinfo.translatey) * frameinfo.scaley *standard_scaley) + pos.x,
                        ((frameinfo.vertices[vert_index].z + frameinfo.translatez) * frameinfo.scalez *standard_scaley) + pos.y,
                        ((frameinfo.vertices[vert_index].x + frameinfo.translatex) * frameinfo.scalex *standard_scaley) + pos.z),
               ptLeaf,1);
        // pump into opengl

        end;
    //glEnd;

 end;//while

end;

procedure freemodel(mdlObject : pmodel);
begin
if (mdlObject.Frames <> nil) and (mdlObject.GlCmds <> nil) then
begin
   freemem(mdlObject.Frames,mdlObject.Info.Framesize * mdlObject.Info.NumFrames);
   freemem(mdlObject.GlCmds,mdlObject.Info.NumGlCommands * sizeof(longint));
   mdlObject.Frames := nil;
   mdlObject.GlCmds := nil;
end;
end;

end.
